
// This creates a game object that will be loaded and saved into
// mission files through save-games.  (Call this create function if
// the object being create should be saved and loaded in the game.)
function CreateSaveObject(%datablock, %name, %team)
{
   %object = new SLGameObj(%name)
   {
      dataBlock = %datablock;
      canSaveDynamicFields = false;
      teamNumber = %team;
      skin = %datablock.skin;
   };

   %object.Initialize();
   MissionGroup.add(%object);
   return %object;
}

// This creates a game object that will not be loaded and saved
// into the mission files through save-games.  (Call this create
// function if the object does not need to be saved and loaded.)
function CreateObject(%datablock, %name, %team)
{
   if (%datablock $= "Bridge")
   {
      %object = new SLLinkObj(%name)
      {
         dataBlock = %datablock;
         teamNumber = %team;
      };
   }
   else
   {   
      %object = new SLGameObj(%name)
      {
         dataBlock = %datablock;
         teamNumber = %team;
         skin = %datablock.skin;
      };
   }
   
   %object.Initialize();
   MissionCleanup.add(%object);
   return %object;
}

function SLGameObj::onAdd(%object)
{
   // if the mission is in the process of being loaded, rely on
   // existing props for placement
   if ($MissionLoaded == false)
   {
      return;
   }
   
   // otherwise, initialize the props based on the object's ai
   if (%object.getTeam() == $OST_PLAYER)
   {
      %ai = slgQueryInterface(%object, $CID_AI);
      if (isObject(%ai) == true)
      {
         RestoreCharacterOutfit(%ai, true);
      }
   }
   else
   {
      // mount base items
      %datablock = %object.getDataBlock();
      %baseMountCount = %datablock.getMountCount();
      for (%index = 0; %index < %baseMountCount; %index++)
      {
         %mountObject = %datablock.GetMountObject(%index);
         %mountPosition = %datablock.getMountPosition(%index);
         %object.unmountImage(%mountPosition);
         %object.mountImage(%mountObject, %mountPosition);
      }
   }
}

function SLGameObj::Initialize(%object)
{
   %datablock = %object.getDataBlock();
   if (isObject(%datablock) == false)
   {
      return;
   }
   
   %object.rotateZ(%datablock.creationAngle);
   if (%team == $OST_PLAYER)
   {
      %object.skin = %datablock.skin;
   }
}

// This changes the state that an object is in.  If the object is
// in the save state, pass false to the function to make it not
// saveable; otherwise pass true to make the object saveable.
function SLGameObj::SaveObject(%object, %save)
{
   if (%save == true)
   {
      if (MissionCleanup.isMember(%object) == true)
      {
         MissionCleanup.remove(%object);
      }
      MissionGroup.add(%object);
   }
   else
   {
      if (MissionGroup.isMember(%object) == true)
      {
         MissionGroup.remove(%object);
      }
      MissionCleanup.add(%object);
   }
}

// This deletes an object that was created through CreateSaveObject
// OR CreateObject.
function SLGameObj::DeleteObject(%object)
{
   if (%object.isLinkObj() == true)
   {
      %link = %object.getFirstLinkObj();
      %first = %link;
      while (isObject(%link) == true)
      {
         if (MissionGroup.isMember(%link) == true)
         {
            MissionGroup.remove(%link);
         }
         if (MissionCleanup.isMember(%link) == true)
         {
            MissionCleanup.remove(%link);
         }
         %nextLink = %link;
      }
      
      %first.delete();
   }
   else
   {   
      if (MissionGroup.isMember(%object) == true)
      {
         MissionGroup.remove(%object);
      }
      if (MissionCleanup.isMember(%object) == true)
      {
         MissionCleanup.remove(%object);
      }
      %object.delete();
   }
}
